/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import cy.jdkdigital.productivebees.init.ModItems;
import cy.jdkdigital.productivebees.setup.BeeReloadListener;
import cy.jdkdigital.productivebees.util.BeeEffect;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;

public class BeeCreator {
    public static CompoundTag create(ResourceLocation id, JsonObject json) {
        CompoundTag data = new CompoundTag();
        data.m_128359_("id", id.toString());
        TextColor primary = TextColor.m_131268_((String)(json.has("primaryColor") ? json.get("primaryColor").getAsString() : "#edc343"));
        TextColor secondary = TextColor.m_131268_((String)(json.has("secondaryColor") ? json.get("secondaryColor").getAsString() : "#804f40"));
        data.m_128405_("primaryColor", primary.m_131265_());
        data.m_128405_("secondaryColor", secondary.m_131265_());
        if (json.has("description")) {
            data.m_128359_("description", json.get("description").getAsString());
        }
        if (json.has("flowerTag") && !json.get("flowerTag").getAsString().isEmpty()) {
            data.m_128359_("flowerTag", json.get("flowerTag").getAsString());
        } else if (json.has("flowerBlock") && !json.get("flowerBlock").getAsString().isEmpty()) {
            data.m_128359_("flowerBlock", json.get("flowerBlock").getAsString());
        } else if (json.has("flowerFluid") && !json.get("flowerFluid").getAsString().isEmpty()) {
            data.m_128359_("flowerFluid", json.get("flowerFluid").getAsString());
        }
        if (json.has("nestingPreference")) {
            data.m_128359_("nestingPreference", json.get("nestingPreference").getAsString());
        }
        if (json.has("beeTexture")) {
            data.m_128359_("beeTexture", json.get("beeTexture").getAsString());
        }
        if (json.has("combTexture")) {
            data.m_128359_("combTexture", json.get("combTexture").getAsString());
        }
        if (json.has("particleColor")) {
            data.m_128405_("particleColor", TextColor.m_131268_((String)json.get("particleColor").getAsString()).m_131265_());
        }
        data.m_128405_("tertiaryColor", json.has("tertiaryColor") ? TextColor.m_131268_((String)json.get("tertiaryColor").getAsString()).m_131265_() : data.m_128451_("primaryColor"));
        if (json.has("attackResponse")) {
            data.m_128359_("attackResponse", json.get("attackResponse").getAsString());
        }
        data.m_128359_("breedingItem", json.has("breedingItem") ? json.get("breedingItem").getAsString() : "");
        data.m_128405_("breedingItemCount", json.has("breedingItemCount") ? json.get("breedingItemCount").getAsInt() : 1);
        data.m_128359_("flowerType", json.has("flowerType") ? json.get("flowerType").getAsString() : "blocks");
        data.m_128359_("renderer", json.has("renderer") ? json.get("renderer").getAsString() : "default");
        data.m_128359_("renderTransform", json.has("renderTransform") ? json.get("renderTransform").getAsString() : "none");
        data.m_128359_("particleType", json.has("particleType") ? json.get("particleType").getAsString() : "drip");
        data.m_128350_("size", json.has("size") ? json.get("size").getAsFloat() : 1.0f);
        data.m_128350_("speed", json.has("speed") ? json.get("speed").getAsFloat() : 1.0f);
        data.m_128347_("attack", json.has("attack") ? (double)json.get("attack").getAsFloat() : 2.0);
        data.m_128379_("translucent", json.has("translucent") && json.get("translucent").getAsBoolean() || data.m_128461_("renderer").equals("translucent_with_center"));
        data.m_128379_("useGlowLayer", !json.has("useGlowLayer") || json.get("useGlowLayer").getAsBoolean());
        data.m_128379_("fireproof", json.has("fireproof") && json.get("fireproof").getAsBoolean());
        data.m_128379_("withered", json.has("withered") && json.get("withered").getAsBoolean());
        data.m_128379_("blinding", json.has("blinding") && json.get("blinding").getAsBoolean());
        data.m_128379_("draconic", json.has("draconic") && json.get("draconic").getAsBoolean());
        data.m_128379_("slimy", json.has("slimy") && json.get("slimy").getAsBoolean());
        data.m_128379_("teleporting", json.has("teleporting") && json.get("teleporting").getAsBoolean());
        data.m_128379_("munchies", json.has("munchies") && json.get("munchies").getAsBoolean());
        data.m_128379_("redstoned", json.has("redstoned") && json.get("redstoned").getAsBoolean());
        data.m_128379_("stringy", json.has("stringy") && json.get("stringy").getAsBoolean());
        data.m_128379_("stingless", json.has("stingless") && json.get("stingless").getAsBoolean());
        data.m_128379_("waterproof", json.has("waterproof") && json.get("waterproof").getAsBoolean());
        data.m_128379_("coldResistant", json.has("coldResistant") && json.get("coldResistant").getAsBoolean());
        data.m_128379_("selfbreed", !json.has("selfbreed") || json.get("selfbreed").getAsBoolean());
        data.m_128379_("selfheal", json.has("selfheal") && json.get("selfheal").getAsBoolean());
        data.m_128379_("irradiated", json.has("irradiated") && json.get("irradiated").getAsBoolean());
        ListTag invulnerability = new ListTag();
        if (json.has("invulnerability")) {
            for (JsonElement damageSource : json.get("invulnerability").getAsJsonArray()) {
                invulnerability.add((Object)StringTag.m_129297_((String)damageSource.getAsString()));
            }
        }
        data.m_128365_("invulnerability", (Tag)invulnerability);
        if (json.has("attributes")) {
            for (Map.Entry entry : json.get("attributes").getAsJsonObject().entrySet()) {
                switch ((String)entry.getKey()) {
                    case "productivity": 
                    case "endurance": 
                    case "temper": 
                    case "behavior": 
                    case "weather_tolerance": {
                        data.m_128405_((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsInt());
                    }
                }
            }
        }
        if (json.has("passiveEffects")) {
            HashMap<MobEffect, Integer> effects = new HashMap<MobEffect, Integer>();
            for (JsonElement el : json.get("passiveEffects").getAsJsonArray()) {
                JsonObject effect = el.getAsJsonObject();
                effects.put((MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(new ResourceLocation(effect.get("effect").getAsString())), effect.get("duration").getAsInt());
            }
            data.m_128365_("effect", (Tag)new BeeEffect(effects).serializeNBT());
        }
        data.m_128379_("createComb", !json.has("createComb") || json.get("createComb").getAsBoolean());
        return data;
    }

    public static void setTag(String type, ItemStack stack) {
        CompoundTag tag = stack.m_41698_("EntityTag");
        tag.m_128359_("type", type);
    }

    public static ItemStack getSpawnEgg(String beeType) {
        ItemStack egg;
        if (BeeReloadListener.INSTANCE.getData(beeType) != null) {
            egg = new ItemStack((ItemLike)ModItems.CONFIGURABLE_SPAWN_EGG.get());
            BeeCreator.setTag(beeType, egg);
        } else {
            ResourceLocation name = new ResourceLocation(beeType);
            egg = name.m_135827_().equals("productivebees") ? new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(new ResourceLocation(name.m_135827_(), "spawn_egg_" + name.m_135815_()))) : new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(new ResourceLocation(name.m_135827_(), name.m_135815_() + "_spawn_egg")));
        }
        return egg;
    }
}

